from timeit import timeit
import numpy as np
from torch.utils.data import WeightedRandomSampler

print(timeit("np.random.randint(0, 1000000, 256)", number=1000, 
    setup=r'import numpy as np; p=np.random.randint(0,10000,1000000); p=p/p.sum()'))

print(timeit("np.random.choice(1000000, 256, replace=False, p=p)", number=100, 
    setup=r'import numpy as np; p=np.random.randint(0,10000,1000000); p=p/p.sum()')*10)


print(timeit("np.random.choice(1000000, 256000, replace=True, p=p)", number=1, 
    setup=r'import numpy as np; p=np.random.randint(0,10000,1000000); p=p/p.sum()'))

print(timeit("list(sampler)", number=1000, 
    setup=r'import numpy as np; p=np.random.randint(0,10000,1000000); p=p/p.sum(); \
        from torch.utils.data import WeightedRandomSampler; \
        sampler = WeightedRandomSampler(p, 256, replacement=True)'))


